/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer;

import com.aptana.explorer.internal.ui.SingleProjectView;
import com.aptana.scripting.ScriptUtils;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ContextContributor;
import com.aptana.scripting.model.WorkingDirectoryType;
import com.aptana.ui.util.UIUtils;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.services.IEvaluationService;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class ExplorerContextContributor
implements ContextContributor {
    private static final String TM_SELECTED_FILES = "TM_SELECTED_FILES";
    private static final String PROJECT_PROPERTY_NAME = "project";
    private static final String PROJECT_RUBY_CLASS = "Project";

    private IProject getActiveProject() {
        final IProject[] projects = new IProject[1];
        try {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
                    if (evaluationService != null) {
                        Object selection;
                        IFile file;
                        IEditorInput editorInput;
                        IEvaluationContext currentState = evaluationService.getCurrentState();
                        Object part = currentState.getVariable("activePart");
                        if (part instanceof IEditorPart && (editorInput = (IEditorInput)currentState.getVariable("activeEditorInput")) instanceof IFileEditorInput && (file = ((IFileEditorInput)editorInput).getFile()) != null) {
                            projects[0] = file.getProject();
                            if (projects[0] != null) {
                                return;
                            }
                        }
                        if ((selection = currentState.getVariable("selection")) instanceof IStructuredSelection) {
                            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
                            IResource resource = null;
                            if (selectedObject instanceof IResource) {
                                resource = (IResource)selectedObject;
                            } else if (selectedObject instanceof IAdaptable) {
                                IAdaptable adaptable = (IAdaptable)selectedObject;
                                resource = (IResource)adaptable.getAdapter(IResource.class);
                            }
                            if (resource != null) {
                                projects[0] = resource.getProject();
                            }
                        }
                    }
                    if (projects[0] != null) {
                        return;
                    }
                    IWorkbenchPage page = UIUtils.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IViewReference[] refs = page.getViewReferences();
                    if (refs == null) {
                        return;
                    }
                    IViewReference[] iViewReferenceArray = refs;
                    int n = refs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject activeProject;
                        SingleProjectView view;
                        IViewReference ref = iViewReferenceArray[n2];
                        if (ref != null && ref.getId().equals("com.aptana.explorer.view") && (view = (SingleProjectView)ref.getPart(false)) != null && (activeProject = view.getActiveProject()) != null) {
                            projects[0] = activeProject;
                            return;
                        }
                        ++n2;
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (projects[0] != null) {
            return projects[0];
        }
        IPreferencesService preferencesService = Platform.getPreferencesService();
        String activeProjectName = preferencesService.getString("com.aptana.explorer", "activeProject", null, null);
        IProject result = null;
        if (activeProjectName != null) {
            result = ResourcesPlugin.getWorkspace().getRoot().getProject(activeProjectName);
        }
        return result;
    }

    public void modifyContext(CommandElement command, CommandContext context) {
        IProject project = this.getActiveProject();
        if (project != null && command != null) {
            Ruby runtime;
            if (command.getWorkingDirectoryType().equals((Object)WorkingDirectoryType.CURRENT_PROJECT)) {
                command.setWorkingDirectoryPath(project.getLocation());
            }
            if ((runtime = command.getRuntime()) != null) {
                IRubyObject rubyInstance = ScriptUtils.instantiateClass((Ruby)runtime, (String)"Ruble", (String)PROJECT_RUBY_CLASS, (IRubyObject[])new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)project)});
                context.put(PROJECT_PROPERTY_NAME, (Object)rubyInstance);
            } else {
                context.put(PROJECT_PROPERTY_NAME, null);
            }
            this.addSelectedFiles(context);
        }
    }

    private void addSelectedFiles(CommandContext context) {
        final IStructuredSelection[] structuredSelection = new IStructuredSelection[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
                if (evaluationService != null) {
                    IEvaluationContext currentState = evaluationService.getCurrentState();
                    Object variable = currentState.getVariable("selection");
                    if (variable instanceof IStructuredSelection) {
                        structuredSelection[0] = (IStructuredSelection)variable;
                    } else {
                        IEditorInput editorInput;
                        variable = currentState.getVariable("activeEditor");
                        if (variable instanceof IEditorPart && (editorInput = ((IEditorPart)variable).getEditorInput()) instanceof IFileEditorInput) {
                            structuredSelection[0] = new StructuredSelection((Object)((IFileEditorInput)editorInput).getFile());
                        }
                    }
                }
            }
        });
        if (structuredSelection[0] == null) {
            CommonNavigator nav = this.getAppExplorer();
            if (nav == null) {
                return;
            }
            ISelection sel = nav.getCommonViewer().getSelection();
            if (sel instanceof IStructuredSelection) {
                structuredSelection[0] = (IStructuredSelection)sel;
            }
        }
        if (structuredSelection[0] == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        IStructuredSelection struct = structuredSelection[0];
        Object[] objectArray = struct.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath location;
            Object selected = objectArray[n2];
            if (selected instanceof IResource && (location = ((IResource)selected).getLocation()) != null) {
                builder.append("'").append(location.toOSString()).append("' ");
            }
            ++n2;
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
            context.put(TM_SELECTED_FILES, (Object)builder.toString());
        }
    }

    private CommonNavigator getAppExplorer() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IViewReference[] refs;
            IViewReference[] iViewReferenceArray = refs = window.getActivePage().getViewReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewPart part;
                IViewReference ref = iViewReferenceArray[n2];
                if (ref.getId().equals("com.aptana.explorer.view") && (part = ref.getView(false)) instanceof CommonNavigator) {
                    return (CommonNavigator)part;
                }
                ++n2;
            }
        }
        return null;
    }
}

